//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;

	/// <summary>
	/// Represents a cash sale.
	/// </summary>
	/// <TgData>
	/// </TgData>
    public interface ICashSale : IDataItem
    {
		/// <summary>
		/// Returns a number of sale positions.
		/// </summary>
		int getPositionCount();

		/// <summary>
		/// Gets the sale position at the specified index.
		/// </summary>
		/// <param name="index"> The position index </param>
        ISalePosition getPositionAt( int index );

		/// <summary>
		/// Adds new position to the sale.
		/// </summary>
		/// <param name="newPosition"> The sale position </param>
		void addPosition( ISalePosition newPosition );

		/// <summary>
		/// Returns the sale date.
		/// </summary>
		DateTime getSaleDate();

		/// <summary>
		/// Calculates the sale subtotal.
		/// </summary>
		Decimal getSubTotal();

		/// <summary>
		/// Calculates the sale tax.
		/// </summary>
		Decimal getTax();

		/// <summary>
		/// Calculates the sale total.
		/// </summary>
		Decimal getTotal();

		/// <summary>
		/// Returns the payment amount.
		/// </summary>
		Decimal getPayment();

		/// <summary>
		/// Performs the payment operation.
		/// </summary>
		/// <param name="payment"> The payment amount </param>
		bool setPayment( Decimal payment );

		/// <summary>
		/// Returns the sale change.
		/// </summary>
		Decimal getChange();

		/// <summary>
		/// Indicates whether the total operation is available.
		/// </summary>
		bool isTotalAvailable();

		/// <summary>
		/// Indicates whether the payment operation is available.
		/// </summary>
		bool isPaymentAvailable();

		/// <summary>
		/// Performs the total operation.
		/// </summary>
		bool makeTotal();

		/// <summary>
		/// Indicates whether the total was completed.
		/// </summary>
		bool hasTotal();

		/// <summary>
		/// Indicates whether the payment was completed.
		/// </summary>
		bool hasPayment();

		/// <summary>
		/// Indicates whether the sale is completed and ready to save.
		/// </summary>
		bool isValid();

		/// <summary>
		/// Checks whether the specified amount is valid to perform the payment.
		/// </summary>
		/// <param name="payment"> The amount </param>
		bool isPaymentValid( Decimal payment );
    }
}
